@echo off
REM Create Desktop Shortcut for Scorbit Desktop
REM Run this script to add a shortcut to your desktop

set "SCRIPT_DIR=%~dp0"
set "EXE_PATH=%SCRIPT_DIR%bin\scorbit_desktop.exe"
set "SHORTCUT_NAME=Scorbit Desktop.lnk"
set "DESKTOP=%USERPROFILE%\Desktop"

echo Creating desktop shortcut for Scorbit Desktop...

REM Use PowerShell to create the shortcut (single line command)
powershell -NoProfile -ExecutionPolicy Bypass -Command "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%DESKTOP%\%SHORTCUT_NAME%'); $s.TargetPath = '%EXE_PATH%'; $s.WorkingDirectory = '%SCRIPT_DIR%bin'; $s.Description = 'Launch Scorbit Desktop'; $s.Save(); Write-Host 'Desktop shortcut created successfully!'"

if %ERRORLEVEL% EQU 0 (
    echo.
    echo Shortcut created: %DESKTOP%\%SHORTCUT_NAME%
    echo.
) else (
    echo.
    echo Failed to create shortcut. Please create it manually.
    echo.
)

pause
